const jwt = require("jsonwebtoken");
const validateFunction = require("../functions/validation");
const userFunction = require("../functions/user");
const otpFunction = require("../functions/otpFunction");
const emailFunction = require("../functions/email");

const signup = async (req, res) => {
    try {
        const validate = await validateFunction.validateUser(req);
        console.log("first :", validate);
        // return
        if(validate){
            return res.status(200).json({
                success: false,
                msg: "User Already Exist!"
            })
        } else {
            const user = await userFunction.signup(req);
            const token = jwt.sign({
                _id: user._id,
                email: user.email,
            }, process.env.SECRET_KEY, { expiresIn: "1y" });

            return res.status(200).json({
                success: true,
                msg: "User Signed-Up Successfully!",
                data: {
                    _id: user._id,
                    email: user.email
                },
                accessToken: token
            });
        }
    } catch (error) {
        console.log("Having Errors :", error);
        return res.status(400).json({
            success: false,
            msg: "Something Went Wrong!",
            error: error.message
        })
    }
};

const login = async (req, res) => {
    try {
        const validate = await validateFunction.validateUser(req);
        if(!validate){
            return res.status(200).json({
                success: false,
                msg: "No Acoount Found!"
            })
        } else {
            const user = await userFunction.getUser(req);
            const hash = user.password;
            const password = req.body.password;
            const verify = await validateFunction.verifyPassword(password, hash);
            if(!verify){
                return res.status(200).json({
                    success: false,
                    msg: "Invalid Credentials!",
                })
            } else {
                req.body.userId = user._id;
                const userData = await userFunction.getUserData(req);   
                const token = jwt.sign({
                    _id: user.id,
                    email: user.email
                }, process.env.SECRET_KEY, { expiresIn: "1y" });

                return res.status(200).json({
                    success: true,
                    msg: "User Logged-In Successfully!",
                    data: userData,
                    accessToken: token 
                })
            }
        };
    } catch (error) {
        console.log("Having Errors :", error);
        return res.status(400).json({
            success: false,
            msg: "Something Went Wrong!",
            error: error.message
        })
    }
};

const getUserById = async (req, res) => {
    try {
        const user = await userFunction.getUserById(req);
        if(!user){
            return res.status(200).json({
                success: false,
                msg: "No User Found By Id!"
            })
        } else {
            return res.status(200).json({
                success: true,
                msg: "User Details By Id!",
                data: user
            })
        }
    } catch (error) {
        console.log("Having Errors :", error);
        return res.status(400).json({
            success: false,
            msg: "Something Went Wrong!",
            error: error.message
        })
    }
};

const updateUser = async (req, res) => {
    try {
        const user = await userFunction.updateUser(req);
        if(!user){
            return res.status(200).json({
                success: false,
                msg: "No User Found To Update!"
            })
        } else {
            return res.status(200).json({
                success: true,
                msg: "User Updated Successfully!",
                data: user
            })
        }
    } catch (error) {
        console.log("Having Errors :", error);
        return res.status(400).json({
            success: false,
            msg: "Something Went Wrong!",
            error: error.message
        })
    }
};

const forgetPassword = async (req, res) => {
    try {
        const validate = await validateFunction.validateUser(req);
        if(!validate){
            return res.status(200).json({
                success: false,
                msg: "User Not Found!"
            })
        } else {
            const generateOTP = await otpFunction.createOTP(req);
            const user = await userFunction.getUser(req);
            const userData = {
                userId: user._id,
                email: generateOTP.email,
                OTP: generateOTP.OTP
            };

            const sendEmail = await emailFunction.sendOTP(userData);
            return res.status(200).json({
                success: true,
                msg: "OTP Sent Successfully!",
                data: userData 
            })
        }
    } catch (error) {
        console.log("Having Errors :", error);
        return res.status(400).json({
            success: false,
            msg: "Something Went Wrong!",
            error: error.message
        })
    }
};

const verifyOTP = async (req, res) => {
    try {
        const verify = await otpFunction.verifyOTP(req);
        if(!verify){
            return res.status(200).json({
                success: false,
                msg: "Invalid OTP!"
            })
        } else {
            return res.status(200).json({
                success: true,
                msg: "OTP Verified Successfully!"
            })
        }
    } catch (error) {
        console.log("Having Errors :", error);
        return res.status(400).json({
            success: false,
            msg: "Something Went Wrong!",
            error: error.message
        })
    }
}

const resetPassword = async (req, res) => {
    try {
        const user = await userFunction.changePassword(req);
        if(!user){
            return res.status(200).json({
                success: false,
                msg: "No User Found!"
            })
        } else {
            return res.status(200).json({
                success: true,
                msg: "Password Changed Successfully!" 
            })
        }
    } catch (error) {
        console.log("Having Errors :", error);
        return res.status(400).json({
            success: false,
            msg: "Something Went Wrong!",
            error: error.message
        })
    }
};

const changePassword = async (req, res) => {
    try {
        const user = await userFunction.getUserData(req);
        req.body.email = user.email;
        const userData = await userFunction.getUser(req);
        const hash = userData.password;
        const password = req.body.oldPassword;
        const verify = await validateFunction.verifyPassword(password, hash);
        if(!verify){
            return res.status(200).json({
                success: false,
                msg: "Incorrect Password!" 
            })
        } else {
            const user = await userFunction.changePassword(req);
            return res.status(200).json({
                success: true,
                msg: "Password Changed Successfully!"
            })
        }
    } catch (error) {
        console.log("Having Errors :", error);
        return res.status(400).json({
            success: false,
            msg: "Something Went Wrong!",
            error: error.message
        })
    }
};

const nearbyUsers = async (req, res) => {
    try {
        const users = await userFunction.getNearbyUsers(req);
        if(users.length === 0){
            return res.status(200).json({
                success: false,
                msg: "No Users Found!"
            })
        } else {
            return res.status(200).json({
                success: true,
                msg: "All Nearby Users!",
                data: users
            })
        }
    } catch (error) {
        console.log("Having Errors :", error);
        return res.status(400).json({
            success: false,
            msg: "Something Went Wrong!",
            error: error.message
        })
    }
};

const deleteUser = async (req, res) => {
    try {
        const user = await userFunction.deleteUser(req);
        if(!user){
            return res.status(200).json({
                succes: false,
                msg: "No User Found to Delete"
            })
        } else {
            return res.status(200).json({
                succes: true,
                msg: "User Deleted Successfully!"
            })
        }
    } catch (error) {
        console.log("Having Errors :", error);
        return res.status(400).json({
            success: false,
            msg: "Something Went Wrong!",
            error: error.message
        })
    }
};

module.exports = {
    signup,
    login,
    getUserById,
    updateUser,
    forgetPassword,
    verifyOTP,
    resetPassword,
    changePassword,
    nearbyUsers,
    deleteUser
};